// *** GAUGES *** //

function initGauges() {
  // Define some sections
  var sections = [steelseries.Section(0, 25, 'rgba(0, 0, 220, 0.3)'),
                  steelseries.Section(25, 50, 'rgba(0, 220, 0, 0.3)'),
                  steelseries.Section(50, 75, 'rgba(220, 220, 0, 0.3)')
                ];
  // Define one area
  var areas = [steelseries.Section(75, 100, 'rgba(220, 0, 0, 0.3)')];
  var areas1 = [steelseries.Section(50, 100, 'rgba(220, 0, 0, 0.3)')];
  // Define value gradient for bargraph
  var valGrad = new steelseries.gradientWrapper(0, 100, [ 0, 0.33, 0.66, 0.85, 1],
                  [ new steelseries.rgbaColor(0, 0, 200, 1),
                    new steelseries.rgbaColor(0, 200, 0, 1),
                    new steelseries.rgbaColor(200, 200, 0, 1),
                    new steelseries.rgbaColor(200, 0, 0, 1),
                    new steelseries.rgbaColor(200, 0, 0, 1) 
                  ]);

  // Initializing gauges
  var radial1 = new steelseries.Radial('canvasRadial1', {
                  gaugeType: steelseries.GaugeType.TYPE1,
                  size: 250,
                  section: sections,
                  area: areas,
                  titleString: 'Tank 1 Level',
                  unitString: 'Ft',
                  threshold: 75,
                  frameDesign: steelseries.FrameDesign.CHROME,
                  backgroundColor: steelseries.BackgroundColor.BROWN,
                  lcdVisible: true
                });

  var rinv = setInterval(function(){ radial1.setValueAnimated(parseFloat(OPC.get_value("Sine2.Value"))); }, 1000);
  window.intervals.push(rinv);

  // Linear Gauge Section

  // Define some sections
  var sections = [steelseries.Section(-100, -40, 'rgba(0, 0, 220, 0.3)'),
                  steelseries.Section(-40, 40, 'rgba(0, 220, 0, 0.3)'),
                  steelseries.Section(40, 75, 'rgba(220, 220, 0, 0.3)')
                ];

  // Define one area
  var areas = [steelseries.Section(75, 100, 'rgba(220, 0, 0, 0.3)')];

  // Define value gradient for bargraph
  var valGrad = new steelseries.gradientWrapper( -100, 100, [ 0, 0.2, 0.4, 0.6, .8],
                    [ new steelseries.rgbaColor(0, 0, 200, 1),
                      new steelseries.rgbaColor(0, 200, 0, 1),
                      new steelseries.rgbaColor(200, 200, 0, 1),
                      new steelseries.rgbaColor(200, 0, 0, 1),
                      new steelseries.rgbaColor(200, 0, 0, 1) 
                    ]);

  // Initializing gauge
  var linear1 = new steelseries.Linear('canvasLinear1', {
                  titleString: 'Tank 1 Level',
                  unitString: 'Ft',
                  frameDesign: steelseries.FrameDesign.METAL,
                  backgroundColor: steelseries.BackgroundColor.BROWN,
                  threshold: 90,
                  width:250,
                  lcdVisible: true
                });
    // Start the update
  var linv = setInterval(function(){ linear1.setValueAnimated(parseFloat(OPC.get_value("Sine2.Value"))); }, 1000);
  window.intervals.push(linv);
}