window.currentEx = null;
window.startExample = "exTank2";
window.examples = {
  "exDisplay" : {},
  "exAppearance" : {},
  "exGetSet" : {},
  "exPump" : {},
  "exTank2" : {},
  "exGauges" : {
    watch_tags:["Sine2.Value"],
    init: initGauges
  },
  "exTrend" : {
    init: initTrends,
    trend_bindings:[
      {
        chartid:"trend1", 
        samplerate: 1,
        timeframe: 50,
        tags:[
          {
            label: "Random",
            tag: "Random.Value",
            color: "#58D3F7",
            yaxis: 1,
            lines: {fill:true},
            points: { show: true } 
          },
          {
            label: "Ramp",
            tag: "Ramp.Value",
            color: "#F7D358",
            lines: {fill:false},
            yaxis: 1
          },
          {
            label: "Tank 1 Level",
            tag: "Sine.Value",
            color: "#CC0000",
            lines: {fill:false},
            yaxis: 2
          }
        ],
        retain: 50,
        callback:trendCallback
      }

    ]
  },
  "exAlarm" : {
    alarm_bindings:[
      {
        alarmid:"alarm1", 
        showHistory:true,
        filter: {
          alarmtypes : ["Digital", "High", "High High", "Low", "Low Low", "ROC", "System"]
        },
        columns: [
          { name: "AlarmDateTime", text: "Alarm Date/Time", type: "datetime", visible: true, sort: 'desc', width: '130px', searchable: false }, 
          { name: "Active", text: "Active", type: "boolean", visible: true, width: '50px', align: 'center' }, 
          { name: "AlarmValue", text: "Alarm Value", type: "string", visible: false, align: 'right' }, 
          { name: "Text", text: "Text", type: "string", visible: true }, 
          { name: "AlarmType", text: "Alarm Type", type: "string", visible: true }, 
          { name: "Acked", text: "Acked", type: "boolean", visible: false }
        ]
      },
      {
        alarmid:"alarm2",
        showHistory:false,
        filter: {
          alarmtypes : ["Digital", "High", "High High", "Low", "Low Low", "ROC", "System"]
        },
        columns: [ 
          { name: "AlarmDateTime", text: "Alarm Date/Time", type: "datetime", visible: true, sort: 'desc', width: '130px', searchable: false }, 
          { name: "AlarmType", text: "Alarm Type", type: "string", visible: true }
        ]
      }
    ]
  },
  "exAlarm2" : {
    alarm_bindings:[ { alarmid:"alarm1" } ]
  }
};

window.intervals = [];

// do some initialization when everything on the page has loaded
$(document).ready(function(){
  $("#header #dl_container #dl").click(function(){
    document.location = "http://www.opcsystems.com/downloads/downloads.php";
  });

  // set up the collapsable panels, triggering an open when the header is clicked
  $(".panel-heading").click(function(){
    var ex = $(this).data("ex");
    if (currentEx != ex) {
      // close a panel if it's open
      togglePanel(currentEx, false);
      // open 'this' panel
      togglePanel(ex, true);
    }
  });
  // after a panel opens, force the page to scroll up to the top so contents are in view
  $(".panel-heading").each(function(){
    var codelink = $('<div class="code-link"><i class="fa fa-code"></i> view code example</div>');
    codelink.click(function(){
      $(this).parent().parent().find(".panel-body").hide();
      $(this).parent().parent().find(".panel-body.code").show();
      $(this).hide();
      $(this).parent().find(".demo-link").show()
    });
    var demolink = $('<div class="demo-link"><i class="fa fa-toggle-right"></i> view demo</div>');
    demolink.click(function(){
      $(this).parent().parent().find(".panel-body").show();
      $(this).parent().parent().find(".panel-body.code").hide();
      $(this).hide();
      $(this).parent().find(".code-link").show()
    });
    $(this).append(codelink.hide());
    $(this).append(demolink.hide());

    var ex = $(this).data("ex");
    $("#" + ex).on("shown.bs.collapse", function(){
      $('html, body').animate({scrollTop: $(".panel-heading[data-ex=" + ex + "]").offset().top-10},100);
    });
  });
  // load up example
  window.examplesCount = 0;
  for (ex in examples) { 
    // count up examples in the list
    window.examplesCount++; 
  }
  window.examplesLoaded = 0;
  for (ex in examples) { 
    $("#" + ex).load("examples/" + ex + ".html", function(){
      window.examplesLoaded++;
      // once all the examples are loaded, open up the one marked as startExample
      if (window.startExample && window.examplesLoaded >= window.examplesCount) {
        togglePanel(window.startExample,true);

        // set up syntax hilighting on code examples
        $('pre code').each(function(i, block) { hljs.highlightBlock(block); });
      }
    }); 
  }
});

function stopCurrentEx() {
  // stop server callbacks
  OPC.toggle_refresh(false);
  // clear out any interval timers running
  for (var i=0;i<window.intervals.length;i++) {
    var inv = window.intervals[i];
    clearInterval(inv);
  }
  window.intervals = [];
}

function togglePanel(pnl, show) {
  if (!pnl) return false;
  stopCurrentEx();

  // open or close the panel
  show = show ? "show" : "hide";
  $("#" + pnl).collapse(show);
  var ph = $("#" + pnl);
  var ex = (show == "show") ? pnl : null;
  currentEx = ex;

  // if showing, update the config settings for the chosen example and re-init OPC
  ph.find(".panel-body").show();
  ph.find(".code").hide();
  ph.parent().find(".code-link").hide();
  ph.parent().find(".demo-link").hide();
  if (show == "show") {
    ph.parent().find(".code-link").show();
    wex = window.examples[ex];
    OPC_config.root_elem = "#" + currentEx;
    OPC_config.watch_tags = wex.watch_tags;
    OPC_config.trend_bindings = wex.trend_bindings;
    OPC_config.alarm_bindings = wex.alarm_bindings;
    OPC.init();
    if (wex.init) wex.init();
  }
}


    

          

